/*
 (c)GAFit toolkit $Id: finput.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include "core.h"
#include "job.h"
#include "inputline/line.h"
#include "parameters/parameters.h"
#include "numbers.h"
#include "analytical/analytical.h"
#include "literals/literals.h"
#include "nullist/nllist.h"
#include "cnames.h"
#include "application.h"
#include "banner.h"
#include "finput.h"

void
ReadPrintOptions (JOB * jo)
{
  if (FileExist (jo->file))
    {
      jo->print_ga =
	GetBoolParameter (jo->file, "print", "ga settings", PRINT_SETTINGS);
      jo->print_run =
	GetBoolParameter (jo->file, "print", "runs", PRINT_RUNS);
    }
  else
    {
      printf ("\nCannot read %s\n", jo->file);
      exit (EXIT_FAILURE);
    }
}

int
ReadGaParameters (JOB * jo)
{
  char *tover[] = LIST_CX_TYPE;
  char *tmut[] = LIST_MUT_TYPE;
  char *tdir[] = LIST_DIRECTION;
  char *tmtin[] = LIST_MUT_INTEGER;

  if (jo->test == 0)
    {
      jo->runs = GetIntParameter (jo->file, "job", "runs", RUNS);	//if no test mode, get runs.
    }
  else
    {
      jo->runs = 1;		//in test mode only one run.
    }

  jo->evaluations =
    GetIntParameter (jo->file, "job", "evaluations", MAX_EVALS);
  jo->pop_size =
    GetIntParameter (jo->file, "parameters", "population", POP_SIZE);
  jo->ga.p_cx =
    GetDblParameter (jo->file, "parameters", "crossover rate", CX_RATE);
  jo->ga.blx_alpha =
    GetDblParameter (jo->file, "parameters", "blx_alpha", BLX_ALPHA);
  jo->ga.eta_sbx =
    GetDblParameter (jo->file, "parameters", "eta_sbx", ETA_SBX);
  jo->ga.p_mt =
    GetDblParameter (jo->file, "parameters", "mutation rate", MUT_RATE);
  jo->ga.elite =
    GetBoolParameter (jo->file, "parameters", "elitism", ELITISM);
  jo->ga.size_k =
    GetIntParameter (jo->file, "parameters", "tournament size", TOURNEY);
  jo->ga.cx_type =
    GetFromSetParameter (jo->file, "parameters", "crossover", tover, CX_TYPE,
			 0);
  jo->ga.mutation_type =
    GetFromSetParameter (jo->file, "parameters", "mutation", tmut, MUT_TYPE,
			 0);
  jo->ga.sigma = GetDblParameter (jo->file, "parameters", "sigma", SIGMA);
  jo->ga.mutation_integer =
    GetFromSetParameter (jo->file, "parameters", "integer mutation",
			 tmtin, MUT_INTEGER, 0);
  jo->dir =
    GetFromSetParameter (jo->file, "parameters", "direction", tdir, DIR, 0);
  if (jo->print_ga)
    printGa (stdout, jo);
  if (jo->dir == 0)
    jo->dir = -1;
  else
    jo->dir = 1;
  return 1;
}

void
ReadJobType (JOB * jo)
{
  char *jtype[] = LIST_JOB_TYPES;
  char *jfile;
  char run_command[STRING_MAX];
//check for application key... and replace configuration file
//the rest of configuration default!!!
  jo->file = appConfigure (jo->file);
  jo->jobtype =
    GetFromSetParameter (jo->file, "job", "type", jtype, JOB_TYPE_SIMPLE, 0);
  //evaluates if there is a command processor available
  if (!system (NULL))
    {
      printf ("No command processor available\n");
      exit (EXIT_FAILURE);
    }

  jo->external_command = (char *) malloc (sizeof (char) * STRING_MAX);
  GetStringParameter (jo->file, "job", "command", "./external",
		      jo->external_command, STRING_MAX);
  jo->external_input = (char *) malloc (sizeof (char) * STRING_MAX);
  jo->external_fit = (char *) malloc (sizeof (char) * STRING_MAX);
  jo->external_bounds = (char *) malloc (sizeof (char) * STRING_MAX);
  if (jo->jobtype == JOB_TYPE_AUTO)
    {
      //control transfered to the 'response' file
      snprintf (run_command, STRING_MAX - 1, "%s 0", jo->external_command);
      system (run_command);
      jfile = "response";
      jo->jobtype =
	GetFromSetParameter (jfile, "job", "type", jtype, JOB_TYPE_SIMPLE, 0);
    }
  else
    {
      jfile = jo->file;
    }
  GetStringParameter (jfile, "job", "external input", "external.input",
		      jo->external_input, STRING_MAX);
  GetStringParameter (jfile, "job", "external fit", "external.fit",
		      jo->external_fit, STRING_MAX);
  GetStringParameter (jfile, "job", "bounds", "bounds.txt",
		      jo->external_bounds, STRING_MAX);
  jo->external_coefs = GetIntParameter (jfile, "job", "coefficients", 0);
  jo->final_evaluation =
    GetBoolParameter (jfile, "job", "final evaluation", 0);
  cnFile (jfile, jo->external_coefs);
  if (jo->external_coefs < 1)
    {
      printf ("Coefficients must be set. I don't know its number.\n");
      exit (EXIT_FAILURE);
    }

}


vect_domain
ReadJobExternal (JOB * jo)
{

  int types, j, i;
  //char *tfit[] = LIST_FITS;
  jo->N = jo->external_coefs;
  printSettings (stdout, jo);
  types = 1;
  vect_domain bounds = malloc (sizeof (domain) * jo->N);
  vect_domain tbounds = malloc (sizeof (domain) * jo->N);
  ReadBounds (tbounds, jo->external_bounds, jo->N, 1);
  for (j = 0; j < types; j++)
    {
      for (i = 0; i < jo->N; i++)
	{
	  bounds[j * jo->N + i].min = tbounds[i].min;
	  bounds[j * jo->N + i].max = tbounds[i].max;
	  bounds[j * jo->N + i].gap = tbounds[i].gap;
	  bounds[j * jo->N + i].decimals = tbounds[i].decimals;
	}
    }
  free (tbounds);
  return bounds;
}

void
PrintECoefficients (FILE * outfile, int N)
{
  double *x;
  int i;
  x = LoadBest (OUTPUT_BEST, N);
  fprintf (outfile, "\n\n#\n#Results\n#\n");
  for (i = 0; i < N; i++)
    {
      fprintf (outfile, " %5d %10s   %+15.12f\n", i + 1, CoefName (i), x[i]);
    }
  free (x);
}

double *
LoadBest (char *filename, int howmany)
{
  FILE *best;
  double *x;
  int i;
  x = (double *) malloc (sizeof (double) * howmany);
  if ((best = fopen (OUTPUT_BEST, "rt")) != NULL)
    {
      for (i = 0; i < howmany; i++)
	{
	  fscanf (best, "%lf\n", &x[i]);
	}
      fclose (best);
    }
  return x;
}

void
ReadBounds (domain * v, const char *file, int coefs, int inter)
{
  char *s;
  FILE *f;
  int n = 0;
  int r, l;
  int lines;
  coefs += 1;			//plus text line per each coefs set.
  lines = coefs * inter;
  f = fopen (file, "r");
  if (f)
    {
      l = 0;
      while ((s = InputFileLine (f)) != NULL)
	{
	  l++;
	  if (l - 1 > lines)
	    break;
	  if ((n) % coefs)
	    {
	      r = sscanf (s, "%lf %lf %d", &v->min, &v->max, &v->decimals);
	      if (r < 3)
		{
		  printf ("Bounds - Error reading line %d, text:'%s'.\n", l,
			  s);
		  printf ("         Expected min max isint\n");
		  exit (EXIT_FAILURE);
		}
	      if (!isInt (v->decimals))
		{
		  v->max = cutDecimals (v->max, v->decimals);
		  v->min = cutDecimals (v->min, v->decimals);
		}
	      v->gap = v->max - v->min;
	      v++;
	    }
	  free (s);
	  n++;
	}
      free (s);
      fclose (f);
    }
  else
    {
      printf ("Bounds - File not found: '%s'\n", file);
      exit (EXIT_FAILURE);
    }
  if (lines > l)
    {
      printf ("Bounds - Error, short read, expected %d, found %d lines.\n",
	      lines, l);
      exit (EXIT_FAILURE);
    }
}
