#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <math.h>


#include "core.h"
#include "job.h"
#include "flyctl/flyctl.h"
#include "utils.h"
#include "evaluation.h"

int
eval_external_bulk (JOB * jo, p_ind population)
{
  int i, j;
  int evaluations = 0;
  char run_command[STRING_MAX];
  char line[STRING_MAX];
  FILE *f;
  f = fopen (jo->external_input, "w");
  for (i = 0; i < jo->pop_size; i++)
    {
      for (j = 0; j < jo->N; j++)
	fprintf (f, "%lf\n", population[i].genes[j]);
      fprintf (f, "\n");
    }
  fclose (f);

  snprintf (run_command, STRING_MAX - 1, "%s %d", jo->external_command,
	    jo->pop_size);
  system (run_command);
  fcCheck ();

  f = fopen (jo->external_fit, "r");
  if (!f)
    {
      printf ("%s not found\n\n", jo->external_fit);
      exit (EXIT_FAILURE);
    }
  for (i = 0; i < jo->pop_size; i++)
    {
      fgets (line, STRING_MAX, f);
      sscanf (line, "%lf", &population[i].fitness);
      evaluations++;
    }
  fclose (f);
  return evaluations;
}

void
eval_external (JOB * jo, double *x, double *fit)
{
  int i;
  char run_command[STRING_MAX];
  char line[STRING_MAX];
  FILE *f;

  //write coefficients to file
  f = fopen (jo->external_input, "w");
  for (i = 0; i < jo->N; i++)
    fprintf (f, "%lf\n", x[i]);
  fclose (f);

  //execute evaluate command
  snprintf (run_command, STRING_MAX - 1, "%s 1", jo->external_command);
  system (run_command);
  fcCheck ();

  //read evaluation fit
  f = fopen (jo->external_fit, "r");
  if (!f)
    {
      printf ("%s not found\n\n", jo->external_fit);
      exit (EXIT_FAILURE);

    }
  fgets (line, STRING_MAX, f);
  sscanf (line, "%lf", fit);
  fclose (f);
}

// Evaluates population of individuals
//
int
evaluate_pop (JOB * jo, p_ind population)
{
  int evaluations = 0;

  fflush (stdout);

  ///*****decimal places******* 
  decimalPlaces (jo, population);
  ///**************************

  if (jo->jobtype == JOB_TYPE_BULK)
    {
      evaluations = eval_external_bulk (jo, population);
    }
  else
    {
      for (int i = 0; i < jo->pop_size; i++)
	{
	  // printf ("external evaluation\n");
	  eval_external (jo, population[i].genes, &population[i].fitness);
	  evaluations++;
	}
    }
  return evaluations;
}

int
evaluate_OldPop (JOB * jo)
{
  return evaluate_pop (jo, jo->population);
}

int
evaluate_NewPop (JOB * jo)
{
  return evaluate_pop (jo, jo->new_population);
}
