/*
 (c)GAFit toolkit $Id: core.h 505 2025-01-25 02:06:51Z ro $
*/

#ifndef _GA_H
#define _GA_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <sys/types.h>

#define FALSE			0
#define TRUE			1


// Default Parameter Values
#define TEST		0	//random seed, if != 0, use it to have no randomness
#define RUNS		1
#define MAX_EVALS	5000
#define POP_SIZE	100
#define CX_RATE		0.75
#define BLX_ALPHA	0.5
#define ETA_SBX		2.0
#define MUT_RATE	0.1
#define ELITISM		1
#define TOURNEY		5
#define CX_TYPE		3	//0: Single point; 1: Double Point; 2: BLX-Alpha; 3: SBX
#define LIST_CX_TYPE	 { "spc", "dpc", "blxa", "sbx", NULL }
#define MUT_TYPE	1	//0: Random; 1: Sigma
#define LIST_MUT_TYPE { "random", "sigma", NULL }
#define DIR		0	//0: Minimization; 1: Maximization
#define LIST_DIRECTION	{ "min", "max", NULL }
#define SIGMA		0.1
#define MUT_INTEGER	0	// Mutation operator for integer variables // 0: Random; 1: Adjacent
#define LIST_MUT_INTEGER  { "random", "adjacent", NULL }

#define JOB_TYPE_APPLICATION -1	//-1: an application conf
#define JOB_TYPE_SIMPLE   0	//0: external simple
#define JOB_TYPE_BULK     1	//1: external bulk
#define JOB_TYPE_AUTO     2	//2: external auto (configures itself)
#define LIST_JOB_TYPES { "external", "external bulk", "external auto", NULL}
#define FINAL_EVALUATION FALSE	//if is needed a final evaluation (passing -1 as argument to external program)

#define INTR_TYPE	0	//0:inter 1:intra+inter 2:user-defined
#define LIST_INTR_TYPE	{"inter","all","user-defined",NULL}

#define ALL_COEFFICIENTS TRUE	// all coefficients: yes
#define AUTOW_PRINT 	TRUE	//print checks

#define OUTPUT_FILE	"stats.txt"	// filename for runs output
#define STATS_MAX_LINES 1000	// stats max lines
#define OUTPUT_BEST	"best.txt"	// filename for best rulers


#define INPUT_FILE_JOB		"job.txt"	// filename for job parameters


#define STEP	0.1

#define PREC	1E-6

#define NO_INIT		-5	// uninitialized best
#define STRING_MAX	1024	//string lengths for file names and so.

#define AFIT	"absolute"
#define RFIT 	"relative"
#define UFIT    "user"
#define LIST_FITS  { AFIT, RFIT, UFIT, NULL }

#define PRINT_SETTINGS 		FALSE	//print ga settings
#define PRINT_RUNS 		TRUE	//print runs
#define PRINT_GEOMETRIES 	TRUE	//print geometries
#define PRINT_ANALYTICAL 	TRUE	//print analytical

typedef struct domain domain, *vect_domain;
struct domain
{
  double min;			// minimum value for each gene
  double max;			// maximum value for each gene
  double gap;			// calculated as max-min
  int decimals;			// 0   ->integer
  // 1..8->decimals
  // >8  ->machine precission 
};

// individual
typedef struct individual ind, *p_ind;
struct individual
{
  double *genes;
  double fitness;		// fitness value
};

#endif /*  */
