/*
 (c)GAFit toolkit $Id: core.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <time.h>
#include <stdlib.h>
#include <string.h>

#include "rand.h"
#include "evaluation.h"
#include "selection.h"
#include "crossover.h"
#include "mutation.h"
#include "stats.h"
#include "utils.h"
#include "numbers.h"
#include "flyctl/flyctl.h"
#include "finput.h"
#include "banner.h"
#include "genetic.h"
#include "core.h"

void
algorithm (JOB * jo)
{
  int generation = 1;
  int current_evaluations = 0;
//  ind best, 
  //  ind new_best, 
  ind dummy;
  static int flag = 0;
  int i;

  //to print stats every evaluations/1000
  int last_evals;
  int outputeach = 0;

  if (jo->evaluations < STATS_MAX_LINES / 10)	//100
    outputeach = 1;
  else if (jo->evaluations < STATS_MAX_LINES)	//1000
    outputeach = STATS_MAX_LINES / 10;
  else if (jo->evaluations > STATS_MAX_LINES)	//>1000
    outputeach = jo->evaluations / STATS_MAX_LINES;

  // make and evaluate population
  current_evaluations = initializePopulation (jo);

  dummy = get_best (jo);
  copia_ind (&dummy, &jo->best, jo->N);
  if (flag == 0)
    {
      flag = 1;
      copia_ind (&jo->best, &jo->all_time_best, jo->N);
    }

  else
    update_all_time_best (jo);

  stats (jo, generation, current_evaluations);

  last_evals = current_evaluations;

  // allocates memory for individuals (to generate the new population)
  initializeNewPopulation (jo);

  // evolution cycle
  do
    {
      generation++;
//*******************************************************
      current_evaluations += genetic (jo);
//*******************************************************
      update_all_time_best (jo);

      // output stats each 'outputeach' evaluations
      if (current_evaluations - last_evals > outputeach)
	{
	  last_evals = current_evaluations;
	  stats (jo, generation, current_evaluations);
	}
    }
  while (current_evaluations < jo->evaluations);

  //last stats

  stats (jo, generation, current_evaluations);


  for (i = 0; i < jo->pop_size; i++)
    {
      free (jo->population[i].genes);
      free (jo->new_population[i].genes);
    }
  free (jo->population);
  free (jo->new_population);
  free (jo->best.genes);
  free (jo->new_best.genes);

  // release memory of old population
}

void
runJob (JOB * jo)
{
  int run;			// current run
  FILE *output;
  time_t t1, t2;
  char randtext[TEXT_RANDOM_SIZE];

  initBest (jo);

  time (&t1);

  for (run = 1; run <= jo->runs; run++)
    {
      //*********** hook to test mode ********//
      init_rand (jo->test, randtext);

      //**************************************//

      if (jo->print_run || jo->test != 0)
	{
	  printRuRa (stdout);
	  if (jo->print_run)
	    {
	      printRun (stdout, run);
	    }
	  printRand (stdout, randtext);
	  printRuRa (stdout);
	}
      jo->last_print = 0;

      // header
      output = fopen (OUTPUT_FILE, "at");
      fprintf (output, "run %d\n", run);
      fprintf (output, "%s", randtext);
      fclose (output);

      algorithm (jo);
      fflush (stdout);
    }

  time (&t2);
  avg_stats (jo->runs, t2 - t1, jo->dir);
  free (jo->bounds);
  cleanJob (jo);
}


// main function
int
main (int argc, char **argv)
{
  JOB job;

  initJob (&job);

  banner (stdout, &job);

  // read print options
  ReadPrintOptions (&job);

  // read GA parameters 
  ReadGaParameters (&job);

  // setup job
  ReadJobType (&job);

  // read data and set job's parameters
  job.bounds = ReadJobExternal (&job);

  if (job.bounds != NULL)
    {
      // Run GA
      runJob (&job);
      if (job.final_evaluation)
	{
	  char run_command[STRING_MAX];
	  snprintf (run_command, STRING_MAX - 1, "%s -1",
		    job.external_command);
	  system (run_command);
	  fcCheck ();
	}
      else
	{
	  PrintECoefficients (stdout, job.N);
	}
    }
  else
    {
      printf ("\nEND\n");
    }
  return 0;
}
