/*
(c) GAFit toolkit $Id: ucompiler.c 181 2016-07-12 10:21:58Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "../inputline/line.h"
#include "../pack/pack.h"
#include "../nullist/nllist.h"
#include "../bytecodes/bytecodes.h"
#include "../rstrings/rstrings.h"
#include "ucompiler.h"

#ifdef __DEBUG__
#define DEBUGPRINT(...)  printf( __VA_ARGS__)
#else
#define DEBUGPRINT(...)		//printf( __VA_ARGS__)
#endif


enum TYPE
{ OPERATOR, PARENS, WHITE, FUNCTION, VARIABLE, NUMBER, FUNCSEPARATOR,
  EXPSEPARATOR
};

enum LR
{ LEFT, RIGHT, NONE };

char **uTokenType (enum TYPE what);
char **uTokenLr (enum TYPE what, enum LR lr);

typedef struct
{
  char *string;
  enum TYPE type;
  enum LR lr;
  int prec;
  int args;
  char *assem;
  enum BYTECODE bc;
} TOKEN;

TOKEN tokens[] = {
  {"=", OPERATOR, RIGHT, 0, 2, "store", STORE},
  {"+", OPERATOR, LEFT, 1, 2, "add", ADD},
  {"-", OPERATOR, LEFT, 1, 2, "sub", SUB},
  {"/", OPERATOR, LEFT, 2, 2, "div", DIV},
  {"*", OPERATOR, LEFT, 2, 2, "mult", MULT},
  {"unary+", OPERATOR, RIGHT, 3, 1, NULL, NOP},
  {"unary-", OPERATOR, RIGHT, 3, 1, "neg", NEG},
  {"**", OPERATOR, RIGHT, 4, 2, "pow", POW},
  {"^", OPERATOR, RIGHT, 4, 2, "pow", POW},
  {"(", PARENS, LEFT, -1, 0, NULL, NOP},
  {")", PARENS, RIGHT, -1, 0, NULL, NOP},
  {" ", WHITE, NONE, -1, 0, NULL, NOP},
  {"\t", WHITE, NONE, -1, 0, NULL, NOP},
  {"\n", WHITE, NONE, -1, 0, NULL, NOP},
  {",", FUNCSEPARATOR, NONE, -1, 0, NULL, NOP},
  {";", EXPSEPARATOR, NONE, 10, 0, NULL, NOP},
  {"", VARIABLE, NONE, -1, 0, NULL, NOP},
  {"", NUMBER, NONE, -1, 0, NULL, NOP},
  {"exp", FUNCTION, NONE, -1, 1, "exp", EXP},
  {"pow", FUNCTION, NONE, -1, 1, "pow", POW},
  {"sin", FUNCTION, NONE, -1, 1, "sin", SIN},
  {"cos", FUNCTION, NONE, -1, 1, "cos", COS},
  {"sqrt", FUNCTION, NONE, -1, 1, "sqrt", SQRT},
  {NULL, OPERATOR, NONE, 0, 0, NULL, NOP}
  //last in the list.
};

//common variables
//**********************************

char **operators = NULL;
char **functions = NULL;
char **variables = NULL;
char **numbers = NULL;
char **allTokens = NULL;
char **whitespace = NULL;
char **lparenthesis = NULL;
char **rparenthesis = NULL;
char **funcseparator = NULL;
char **expseparator = NULL;
//**********************************


char **
uTokenType (enum TYPE what)
{
  char **w = NULL;
  TOKEN *p = tokens;
  while (p->string)
    {
      if (p->type == what)
	w = nllAddDup (w, p->string);
      p++;
    }
  return w;
}

char *
uAssemblerText (char *what)
{
  TOKEN *p = tokens;
  char lcase[10];
  while (p->string)
    {
      strncpy (lcase, what, 9);
      sLowerCase (lcase);
      if (!nllStrCmp (p->string, what) || !nllStrCmp (p->string, lcase))
	return p->assem;
      p++;
    }
  return NULL;
}

enum BYTECODE
uToken2Bytecode (char *what)
{
  TOKEN *p = tokens;
  char lcase[10];
  while (p->string)
    {
      strncpy (lcase, what, 9);
      sLowerCase (lcase);
      if (!nllStrCmp (p->string, what) || !nllStrCmp (p->string, lcase))
	return p->bc;
      p++;
    }
  return -1;
}

char **
uTokenLr (enum TYPE what, enum LR lr)
{
  char **w = NULL;
  TOKEN *p = tokens;
  while (p->string)
    {
      if (p->type == what && p->lr == lr)
	w = nllAddDup (w, p->string);
      p++;
    }
  return w;
}



char **
uTokenSet (void)
{
//  char **p, *tmp;
//  int tlen = 0, i, j;
  char **s = NULL;
  if (allTokens)
    return allTokens;

/*
  p = operators;
  while (*p)
    s = nllAdd (s, strdup (*p++));
  p = lparenthesis;
  while (*p)
    s = nllAdd (s, strdup (*p++));
  p = rparenthesis;
  while (*p)
    s = nllAdd (s, strdup (*p++));
  p = whitespace;
  while (*p)
    s = nllAdd (s, strdup (*p++));
  p = funcseparator;
  while (*p)
    s = nllAdd (s, strdup (*p++));
  p = expseparator;
  while (*p)
    s = nllAdd (s, strdup (*p++));
  p = s;
  
  while (*p++)
    tlen++;

  for (i = 0; i < tlen; i++)
    for (j = i + 1; j < tlen; j++)
      if (strlen (s[i]) < strlen (s[j]))
	{
	  tmp = s[j];
	  s[j] = s[i];
	  s[i] = tmp;
	}
*/

  s = nllListAdd (s, operators);
  s = nllListAdd (s, lparenthesis);
  s = nllListAdd (s, rparenthesis);
  s = nllListAdd (s, whitespace);
  s = nllListAdd (s, funcseparator);
  s = nllListAdd (s, expseparator);
  allTokens = nllLenOrder (s);
  return s;
}



//checks unaries
char **
uCheckUnFirst (char **t, char *what, char *with)
{
  char **s = t;
  if (!strcmp (*t, what))
    nllItemReplace (t, with);
  return s;
}

char **
uCheckUnPar (char **t, char *what, char *with)
{
  char **s = t;
  t++;
  while (*t)
    {
      if (!strcmp (*t, what))
	if (nllCompare (*(t - 1), lparenthesis)
	    || nllCompare (*(t - 1), funcseparator)
	    || nllCompare (*(t - 1), operators))
	  nllItemReplace (t, with);
      t++;
    }
  return s;
}

char **
uCheckTypes (char **t)
{
  t = uCheckUnFirst (t, "+", "unary+");
  t = uCheckUnFirst (t, "-", "unary-");
  t = uCheckUnPar (t, "+", "unary+");
  t = uCheckUnPar (t, "-", "unary-");
  return t;
}


//create func list
char **
uCheckFuncs (char **t)
{
  char **s = NULL;
  while (*t)
    {
      if (!nllCompare (*t, uTokenSet ()) && !nllStrCmp (*(t + 1), "("))
	{
	  *t = sUpperCase (*t);
	  s = nllAddDup (s, *t);
	}
      t++;
    }
  return s;
}

//create var list
char **
uCheckVars (char **t)
{
  char **s = NULL;
  while (*t)
    {
      if (!nllCompare (*t, uTokenSet ()) && nllStrCmp (*(t + 1), "("))
	if (*t[0] >= 'a' && *t[0] <= 'z')
	  s = nllAddDup (s, *t);
      t++;
    }
  s = nllUnic (s);
  return s;
}

//create number list
char **
uCheckNums (char **t)
{
  char **s = NULL;
  double d;
  while (*t)
    {
      if (!nllCompare (*t, uTokenSet ()) && nllStrCmp (*(t + 1), "("))
	if (sStr2Double (*t, &d))
	  s = nllAddDup (s, *t);
      t++;
    }
  return s;
}

//checks for floats break appart by parser
//ie: mantisaE+exponent or mantisaE-exponent
char **
uCheckFloats (char **list)
{
  char **s = NULL;
  char **t = list;
  double d;
  char *l;
  while (*t)
    {
      if (!nllCompare (*t, uTokenSet ()) && nllStrCmp (*(t + 1), "("))
	if (sStr2Double (*t, &d) == ISFLOAT)
	  {
	    l = strdup (*t);
	    if (t + 1)
	      {
		if (strcmp (*(t + 1), "-") || strcmp (*(t + 1), "+"))
		  {
		    l =
		      (char *)
		      realloc (l,
			       (strlen (l) + strlen (*(t + 1)) +
				1) * sizeof (char));
		    strcat (l, *(t + 1));
		    if (t + 2)
		      {
			if (sStr2Double (*(t + 2), &d) == ISNUMBER)
			  {
			    l =
			      (char *) realloc (l,
						(strlen (l) +
						 strlen (*(t + 2)) +
						 1) * sizeof (char));
			    strcat (l, *(t + 2));
			    s = nllAdd (s, l);
			    t += 3;
			    continue;
			  }
		      }
		  }
	      }
	  }
      s = nllAddDup (s, *t);
      t++;
    }
  nllClear (list);
  return s;
}

int
uIsOperator (char *s)
{
  int ret;
  if (nllCompare (s, operators))
    ret = 1;
  else
    ret = 0;
  return ret;
}

int
uPrecedence (char *s)
{
  TOKEN *t = tokens;
  int ret = 0;
  if (!t)
    exit (EXIT_FAILURE);
  while (t->string)
    {
      if (!strcmp (s, t->string))
	{
	  ret = t->prec;
	  break;
	}
      t++;
    }

  return ret;
}

int
uIsLeft (char *s)
{
  int ret = 0;
  char **oleft = uTokenLr (OPERATOR, LEFT);
  if (nllCompare (s, oleft))
    ret = 1;
  nllClear (oleft);
  return ret;
}

int
uIsRight (char *s)
{
  int ret = 0;
  char **oright = uTokenLr (OPERATOR, RIGHT);
  if (nllCompare (s, oright))
    ret = 1;
  nllClear (oright);
  return ret;
}

char **
uRpn (char **t)
{
  char **outbound = NULL;
  char **stack = NULL;
  char **p;
  char *v;
  p = t;
  while (*p)
    {
      DEBUGPRINT ("[%s]", *p);
      if (nllCompare (*p, expseparator))
	{
	  v = nllLook (stack);
	  while (v)
	    {
	      if (nllCompare (v, lparenthesis))
		{
		  nllClear (t);
		  nllClear (stack);
		  nllClear (outbound);
		  printf ("ucompiler ERROR3");
		  return NULL;
		}
	      outbound = nllPopPush (&stack, outbound);
	      v = nllLook (stack);
	    }
	}
      else if (nllCompare (*p, numbers))
	outbound = nllPush (outbound, *p);
      else if (nllCompare (*p, variables))
	outbound = nllPush (outbound, *p);
      else if (nllCompare (*p, functions))
	stack = nllPush (stack, *p);
      else if (nllCompare (*p, funcseparator))
	while (!nllCompare (nllLook (stack), lparenthesis))
	  outbound = nllPopPush (&stack, outbound);
      else if (uIsOperator (*p))
	{
	  v = nllLook (stack);
	  while (uIsOperator (v))
	    {
	      if ((uIsLeft (*p)
		   && (uPrecedence (*p) <=
		       uPrecedence (v)))
		  || (uIsRight (*p) && (uPrecedence (*p) < uPrecedence (v))))
		outbound = nllPopPush (&stack, outbound);
	      else
		break;
	      v = nllLook (stack);
	    }
	  stack = nllPush (stack, *p);
	}
      else if (nllCompare (*p, lparenthesis))
	stack = nllPush (stack, *p);
      else if (nllCompare (*p, rparenthesis))
	{
	  //right parenthesis
	  v = nllLook (stack);
	  if (!v)
	    {
	      nllClear (t);
	      nllClear (stack);
	      nllClear (outbound);
	      printf ("ucompiler ERROR0");
	      return NULL;
	    }
	  while (!nllCompare (v, lparenthesis))
	    {
	      outbound = nllPopPush (&stack, outbound);
	      v = nllLook (stack);
	      if (!v)
		{
		  //runs out without found a lpar
		  nllClear (t);
		  nllClear (stack);
		  nllClear (outbound);
		  printf ("ucompiler ERROR2");
		  return NULL;
		}
	    }
	  nllPopLost (&stack);
	  if (nllCompare (nllLook (stack), functions))
	    outbound = nllPopPush (&stack, outbound);
	}
      else
	stack = nllPush (stack, *p);
      p++;
#ifdef __DEBUG__
      nllPrint (outbound, "out\t");
      printf ("\t|||\t");
      nllPrint (stack, "stack\t");
      printf ("\n");
#endif
    }

  v = nllLook (stack);
  while (v)
    {
      if (nllCompare (v, lparenthesis))
	{
	  nllClear (t);
	  nllClear (stack);
	  nllClear (outbound);
	  printf ("ucompiler ERROR3");
	  return NULL;
	}
      outbound = nllPopPush (&stack, outbound);
      v = nllLook (stack);
    }
  nllClear (t);
  nllClear (stack);
  return outbound;
}

void
uInit (void)
{
  operators = uTokenType (OPERATOR);
  whitespace = uTokenType (WHITE);
  lparenthesis = uTokenLr (PARENS, LEFT);
  rparenthesis = uTokenLr (PARENS, RIGHT);
  funcseparator = uTokenType (FUNCSEPARATOR);
  expseparator = uTokenType (EXPSEPARATOR);
}

void
uFinish (int all)
{
  nllClear (operators);
  nllClear (whitespace);
  nllClear (functions);
  if (all)
    nllClear (variables);
  nllClear (numbers);
  nllClear (allTokens);
  nllClear (lparenthesis);
  nllClear (rparenthesis);
  nllClear (funcseparator);
  nllClear (expseparator);
}

int
uCheckSyn (char **t)
{
  char **list, **alist;
  alist = list = t;
  list++;
  while (*list)
    {
      if (nllCompare (*alist, rparenthesis)
	  || nllCompare (*alist, variables) || nllCompare (*alist, numbers))
	if (nllCompare (*list, variables) || nllCompare (*list, numbers))
	  {
	    printf ("Syntax error here: ");
	    while (t != list)
	      printf ("%s ", *t++);
	    printf ("%s\n", *list);
	    return 0;
	  }
      list++;
      alist++;
    }
  return 1;
}

int
uCheckPar (char **t)
{
  int lpar = 0, rpar = 0;
  char **list;
  list = t;
  while (*list)
    {
      if (nllCompare (*list, rparenthesis))
	rpar++;
      if (nllCompare (*list, lparenthesis))
	lpar++;
      list++;
    }
  if (lpar != rpar)
    return 0;
  return 1;
}


void
uWriteAssembler (char *file, char **result)
{
  FILE *f;
  char **p = result;
  char *fileasm = MakePath (file, ".usm");
  f = fopen (fileasm, "w");
  while (*p)
    {
      fprintf (f, " %s", *p);
      p++;
    }
  fclose (f);
  free (fileasm);
}

void
uWritePack (char *file, void *pack, int len)
{
  FILE *f;
  char *filebin = MakePath (file, ".uxe");
  f = fopen (filebin, "wb");
  fwrite (pack, len, 1, f);
  fclose (f);
  free (filebin);
}


char **
uAssemble (char **l, char *file)
{
  char **p;
  char **w = NULL;
  char *v = NULL;
  int vlen = 0;
  char temp[_MAX_ASM_LINE_];
  int i = 0;
  enum BYTECODE c;
  int a;
  double d;
  p = variables;
  if (p)
    while (*p)
      {
	snprintf (temp, _MAX_ASM_LINE_, "; %s:%d\n", *p, i++);
	w = nllAddDup (w, temp);
	p++;
      }
  p = l;
  while (*p)
    {
      DEBUGPRINT ("assemble:%s\n", *p);
      if (nllCompare (*p, variables))
	{
	  w = nllAddDup (w, "apush");
	  c = APUSH;
	  v = pack (BYTECODE, v, (void *) &c, &vlen);
	  a = nllLocate (*p, variables);
	  snprintf (temp, _MAX_ASM_LINE_, "%d", a);
	  w = nllAddDup (w, temp);
	  w = nllAddDup (w, "\n");
	  v = pack (INT, v, (void *) &a, &vlen);
	}
      if (nllCompare (*p, numbers))
	{
	  w = nllAddDup (w, "push");
	  c = PUSH;
	  v = pack (BYTECODE, v, (void *) &c, &vlen);
	  w = nllAddDup (w, "double");
	  snprintf (temp, _MAX_ASM_LINE_, "%s", *p);
	  d = str2double (*p);
	  w = nllAddDup (w, temp);
	  w = nllAddDup (w, "\n");
	  v = pack (DOUBLE, v, (void *) &d, &vlen);
	}
      if (nllCompare (*p, functions) || nllCompare (*p, operators))
	{
	  snprintf (temp, _MAX_ASM_LINE_, "%s", uAssemblerText (*p));
	  w = nllAddDup (w, temp);
	  w = nllAddDup (w, "\n");
	  c = uToken2Bytecode (*p);
	  v = pack (BYTECODE, v, (void *) &c, &vlen);
	}
      p++;
    }
//  w = nllAdd (w, strdup ("stop"));
  w = nllAddDup (w, "\n");
  v = pack (END, v, (void *) &c, &vlen);
  uWriteAssembler (file, w);
  uWritePack (file, v, vlen);
  nllClear (l);
  free (v);
  return w;
}


char **
uCompile (char *l, char *file, char ***vars)
{

  char **lparsed;
  uInit ();
  sLowerCase (l);
  lparsed = nllParser (l, uTokenSet);
  DEBUGPRINT ("l:%s\n", l);
  DEBUGPRINT ("-------------\n");

  //join again floats break appart by
  //nllParser
  lparsed = uCheckFloats (lparsed);

  lparsed = nllDelete (lparsed, whitespace);
  if (!uCheckPar (lparsed))
    {
      printf ("ucompiler ERROR5");
      uFinish (1);
      nllClear (lparsed);
      return NULL;
    }


  lparsed = uCheckTypes (lparsed);
  functions = uCheckFuncs (lparsed);
  variables = uCheckVars (lparsed);
  numbers = uCheckNums (lparsed);
  if (!functions && !numbers && !variables)
    {
      printf ("ucompiler ERROR04");
      uFinish (1);
      nllClear (lparsed);
      return NULL;
    }
#ifdef __DEBUG__
  nllPrint (functions, "functions:\t");
  printf ("\n");
  nllPrint (variables, "variables:\t");
  printf ("\n");
  nllPrint (numbers, "numbers:\t");
  printf ("\n");
#endif
  if (!uCheckSyn (lparsed))
    exit (EXIT_FAILURE);
  lparsed = uRpn (lparsed);
  lparsed = uAssemble (lparsed, file);
  uFinish (0);
  *vars = variables;
  return lparsed;
}

void
prettyPrintAsm (char **asmcode)
{
  char **p;
  p = asmcode;
  while (*p)
    {
      printf ("\t%s", *p);
      p++;
    }
}
