/*
 (c)GAFit toolkit $Id: cnames.c 539 2025-05-31 22:22:16Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "nullist/nllist.h"
#include "literals/literals.h"
#include "parameters/parameters.h"
#include "cnames.h"

char **cnames = NULL;
char **ftokens = NULL;
char *(*funcpointer) (int) = NULL;

char *
CoefName (int a)
{
  return funcpointer (a);
}

char *
GetCName (int i)
{
  return nllString (cnames, i);
}

char **
cntokens (void)
{
  char **s = NULL;
  if (ftokens)
    return ftokens;
  ftokens = nllAdd (s, strdup ("\n"));
  return ftokens;
}

void
ClearCNames (void)
{
  if (ftokens)
    nllClear (ftokens);

  if (cnames)
    nllClear (cnames);

  ftokens = NULL;
  cnames = NULL;
  funcpointer = NULL;
}


void
cnAdd (char **list)
{
  cnames = nllListAdd (cnames, list);
}

void
cnStandard (int howmany)
{
  int i;
  for (i = 0; i < howmany; i++)
    cnames = nllAdd (cnames, Letters (i));
  funcpointer = GetCName;
}

void
cnFile (char *file, int howmany)
{
  char *l = NULL;
  int i;
  ClearCNames ();
  if (file)
    l = SectionText (file, "coefficient names");
  if (l)
    {
      cnames = nllParser (l, cntokens);
      free (l);
      cnames = nllDelete (cnames, ftokens);
      i = nllCount (cnames);
      if (i < howmany)
	{
	  printf ("there are %d coefficient names, %d required\n", i,
		  howmany);
	  exit (EXIT_FAILURE);
	}
      funcpointer = GetCName;
    }
  else				//if no file or no section, fall back to standard coefficient names
    {
      cnStandard (howmany);
    }
}

void
cnFunction (char *(*OtherMethod) (int))
{
  ClearCNames ();
  funcpointer = OtherMethod;
}

void
printCnames (void)
{
  nllPrint (cnames, "Coefficients names\n");

}
