/*
(c) GAFit toolkitk $Id: chmrunner.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "../flyctl/flyctl.h"
#include "../inputline/line.h"
#include "../rangecf/rangecf.h"
#include "charmm.h"


extern char *ExternalInput;
extern char *ExternalFit;
extern char *InputTemplate;
extern char *CharmmParameters;
extern char *CharmmExecutable;
extern char *CharmmJobFile;
extern char *CharmmReferenceGeom;
extern char *CharmmCalculatedEnergies;

extern double *refenergy;
extern double *refwei;
extern int totalref;

extern char **geoms;

extern int debug;

double *runfit;

void
usage (void)
{
  printf ("chmmrunner v0.1 (c)GAFit toolkit - 2015\n");
  printf
    ("\tUsage: chmmrunner n-of-vectors calc-index-column calc-value-column\n\n");
  exit (EXIT_SUCCESS);
}

void
WriteFit (char *file, int indv)
{
  FILE *w;
  int i;
  w = fopen (file, "w");
  for (i = 0; i < indv; i++)
    {
      fprintf (w, "%g\n", runfit[i]);
    }
  fclose (w);

}

void
EvaluateRun (int i, int icol, int ecol)
{
  double fit;
  loadCalculatedEnergies (CharmmReferenceGeom, icol, ecol);
  checkGeoms ();
  fit = calculateFit ();
  if (debug)
    printf ("fit:%g\n", fit);
  runfit[i] = fit;
}

void
ChmmMachineGun (char *executable, char *jobfile, int ni, RANGECOEFS * rc,
		int icol, int ecol)
{
  FILE *e;
  int i, j;
  char *s, *text, *text2;
  double coefs[rc->ncoefs];
  char cmd[CHMM_COMANDLINE_MAX];

  runfit = malloc (sizeof (double) * ni);

  e = fopen (InputTemplate, "r");
  if (e)
    {
      text = InputFileText (e);
      fclose (e);

      snprintf (cmd, CHMM_COMANDLINE_MAX - 1, CHMM_COMAND_EXEC,
		executable, jobfile, jobfile);
      e = fopen (ExternalInput, "r");
      if (e)
	{
	  for (i = 0; i < ni; i++)
	    {
	      for (j = 0; j < rc->ncoefs; j++)
		{
		  s = InputFileLine (e);
		  if (!s)
		    {
		      printf ("Error External Input!\n");
		      fcStopIt
			("chmmrunner: No input in file ExternalInput\n");
		    }
		  sscanf (s, "%lf", &coefs[j]);
		  free (s);
		}
	      text2 = strdup (text);
	      text2 = rcCreateParameters (text2, coefs, rc);
	      if (text2 == NULL)
		fcStopIt ("Error CreateParameters\n");
	      WriteFile (text2, CharmmParameters);
	      free (text2);

	      system (cmd);

	      EvaluateRun (i, icol, ecol);

	      //blank line
	      s = InputFileLine (e);
	      free (s);
	    }
	}
      free (text);
      fclose (e);
      return;
    }
  fcStopIt ("chmmMachineGun error\n");
}

void
argError (int n)
{
  if (n < 1)
    {
      printf ("Argument error:%d\n", n);
      fcStopIt ("chmmrunner: argument error\n");
    }

}


int
main (int argc, char **argv)
{
  int indv;
  int indexcol, enercol;
  RANGECOEFS *rc;

  rc = rcFactory ();
  fcStartFly ();

  unlink ("response");

  InitEnvironmentVariables ();

  if (argc == 1)
    {
      usage ();
    }
  else if (argc != 4)
    {
      printf ("Error: number of arguments!\n");
      fcStopIt ("chmmrunner: number of arguments\n");
    }
  else
    {
      indv = atoi (argv[1]);
      argError (indv);

      indexcol = atoi (argv[2]);
      argError (indexcol);

      enercol = atoi (argv[3]);
      argError (enercol);

      writeFinalHint (indexcol, enercol, ExternalInput, ExternalFit, argv[0],
		      InputTemplate, CharmmParameters, CharmmExecutable,
		      CharmmJobFile, CharmmReferenceGeom,
		      CharmmCalculatedEnergies);

      if ((rc = rcReadAnalysisResults (ANALYSIS_RESULTS_FILE)) == NULL)
	{
	  fcStopIt ("Error readAnalysisResults\n");
	}
      loadReferenceTable ();
      ChmmMachineGun (CharmmExecutable, CharmmJobFile, indv, rc, indexcol,
		      enercol);
      WriteFit (ExternalFit, indv);
      free (runfit);
      chmmClean (rc);
    }

  return 0;
}
