/*
(c) GAFit toolkitk $Id: chmfinal.c 420 2022-11-24 23:20:50Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>

#include "../inputline/line.h"
#include "../nullist/nllist.h"
#include "../rstrings/rstrings.h"
#include "../rangecf/rangecf.h"
#include "charmm.h"


void
usage (void)
{
  printf ("chmfinal v0.1 (c)GAFit toolkit - 2015\n");
  printf ("\tUsage: chmfinal\n\n");
  exit (EXIT_SUCCESS);
}


void
cpyBest2Input (int n, double *coefs, char *einput)
{
  FILE *w;
  w = fopen (einput, "w");
  for (int i = 0; i < n; i++)
    fprintf (w, "%f\n", coefs[i]);
  fprintf (w, "\n");
  fclose (w);
}

void
end (char *s)
{
  printf ("%s\n", s);
  exit (EXIT_FAILURE);
}

int
main (int argc, char **argv)
{
  FILE *r;
  int i, value;
  char *s;
  int index1, index2;
  double *coefs;
  char einput[MAXSTR], efit[MAXSTR], runcmd[MAXSTR], cmd[MAXSTR],
    template[MAXSTR], parameters[MAXSTR], executable[MAXSTR], job[MAXSTR],
    rgeom[MAXSTR], calculated[MAXSTR];
  RANGECOEFS *rc;

  InitEnvironmentVariables ();
  printf ("\n\n#\n");
  printf ("#FINAL EVALUATION\n");
  printf ("#\n");
  if (argc != 1)
    {
      usage ();
    }
  else
    {
      if ((rc = rcReadAnalysisResults (ANALYSIS_RESULTS_FILE)) == NULL)
	{
	  printf ("error readAnalysisResults\n");
	  exit (EXIT_FAILURE);
	}

      coefs = malloc (sizeof (double) * rc->ncoefs);

      loadReferenceTable ();
      r = fopen ("best.txt", "r");
      if (r)
	{
	  printf ("\t\t\t%15s\n\n", "COEFFICIENTS");

	  for (i = 0; i < rc->ncoefs; i++)
	    {
	      s = InputFileLine (r);
	      if (strcmp (rcGetType (i, rc), "c") == 0)
		{
		  char *tmp;
		  value = atoi (s) - 1;
		  tmp = rcGetChoice (i, value, rc);
		  printf ("\t%d\t%15s:\t%s\n", i, rc->names[i], tmp);
		  free (tmp);
		}
	      else
		{
		  printf ("\t%d\t%15s:\t%s\n", i, rc->names[i], s);
		}

	      if (!sStr2Double (s, &coefs[i]))
		end ("error reading best.txt");

	      free (s);
	    }
	  while ((s = InputFileLine (r)) != NULL)
	    {
	      printf ("\t\t%31s\n", s);
	      free (s);
	    }
	  fclose (r);
	  readFinalHint (&index1, &index2, einput, efit, runcmd, template,
			 parameters, executable, job, rgeom, calculated);
	  cpyBest2Input (rc->ncoefs, coefs, einput);
	  snprintf (cmd, MAXSTR, "%s  %d %d", runcmd, index1, index2);
	  system (cmd);
	  loadCalculatedEnergies (rgeom, index1, index2);
	  printEvaluation ();
	}
    }
  free (coefs);
  chmmClean (rc);
  return 0;
}
