/*
(c) GAFit toolkitk $Id: chmconfigurator.c 332 2018-10-28 14:41:05Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>

#include "../flyctl/flyctl.h"
#include "../rangecf/rangecf.h"
#include "charmm.h"

extern char *ExternalInput;
extern char *ExternalFit;
extern char *Bounds;
extern char *InputTemplate;
extern char *CharmmParameters;

char *ExternalType = EXTERNAL_TYPE_BULK;


int
main (int argc, char **argv)
{
  int indv;
  RANGECOEFS *rc;

  if (argc != 2)
    {
      printf ("\ncharmm configurator v0.1 (c)GAFit toolkit - 2015\n");
      printf ("\tUsage: %s 0\n\n", argv[0]);

      fcStopIt ("charmm configurator: number of arguments\n");
    }

  indv = atoi (argv[1]);

  InitEnvironmentVariables ();

  if (indv == 0)
    {
      fcStartFly ();
      if ((rc =
	   rcAnalyzeTemplate (InputTemplate, ANALYSIS_RESULTS_FILE)) == NULL)
	{
	  fcStopIt ("Analyze Template error\n");
	}

      if (!rcWriteResponse
	  (rc, ExternalType, ExternalInput, ExternalFit, Bounds))
	{
	  fcStopIt ("chmconfigurator Response file\n");
	}

      if (!rcWriteBounds (rc, Bounds, InputTemplate))
	{
	  fcStopIt ("Bounds error");
	}

      chmmClean (rc);
    }
  else
    {
      printf ("Please, only run %s with argument '0'\n", argv[0]);
      fcStopIt ("charmm configurator: argument is not '0'\n");
    }
  return 0;
}
