/*
(c) GAFit toolkit $Id: charmm.h 505 2025-01-25 02:06:51Z ro $
*/

#ifndef _CHARMMC_INTERFACE_
#define _CHARMM_INTERFACE_

#define EXTERNAL_INPUT "charmm.input"
#define EXTERNAL_FIT "charmm.fit"
#define BOUNDS_FILE      "bounds.txt"
#define CHARMM_TEMPLATE "template.prm"
#define CHARMM_PARAMETERS "parameters.prm"
#define CHARMM_JOBFILE "fitting"
#define CHARMM_EXECUTABLE "charmm"

#define CHARMM_GEOMETRIES "geometries"
#define CHARMM_REFERENCE_GEOM "none"

#define  EXTERNAL_TYPE_BULK "external bulk"

#define REFERENCE_TABLE "reference-table"
#define CHARMM_CALCULATED_ENERGIES "calculated.energies"
#define FINAL_HINT "chmfinal-hint"

#define CHMM_COMANDLINE_MAX 255
#define CHMM_COMAND_EXEC "%s < %s.dat >%s.out\n"
#define MAXSTR 4086


#define STR_EXTERNAL_INPUT "EXTERNAL_INPUT"
#define STR_EXTERNAL_FIT "EXTERNAL_FIT"
#define STR_BOUNDS_FILE      "BOUNDS_FILE"
#define STR_INPUT_TEMPLATE "CHARMM_TEMPLATE"
#define STR_CHARMM_PARAMETERS "CHARMM_PARAMETERS"
#define STR_CHARMM_EXECUTABLE "CHARMM_EXECUTABLE"
#define STR_CHARMM_GEOMETRIES "CHARMM_GEOMETRIES"
#define STR_CHARMM_JOBFILE "CHARMM_JOBFILE"
#define STR_CHARMM_PARAMETERS "CHARMM_PARAMETERS"
#define STR_CHARMM_REFERENCE_GEOM "CHARMM_REFERENCE_GEOM"
#define STR_CHARMM_CALCULATED_ENERGIES "CHARMM_CALCULATED_ENERGIES"


void InitEnvironmentVariables (void);
void writeAnalysisResults (char *outTemplate);
int readAnalysisResults (void);
void referenceTable (char *dir, char *reference);
void printAll (void);
int WriteFile (char *content, char *file);
char *CreateParameters (char *t, double *coefs, int nc);

void loadReferenceTable (void);
void loadCalculatedEnergies (char *reference, int icol, int ecol);
double calculateFit (void);
char *getChoice (int i, int value);

void checkGeoms (void);

void chmmClean (RANGECOEFS * rc);
void
writeFinalHint (int i, int e, char *einput, char *efit, char *cmd,
		char *template, char *parameters, char *executable, char *job,
		char *rgeom, char *cener);
void readFinalHint (int *i, int *e, char *einput, char *efit, char *cmd,
		    char *template, char *parameters, char *executable,
		    char *job, char *rgeom, char *cener);
void printEvaluation (void);
#endif
