/*
(c) GAFit toolkit $Id: bytecodes.c 114 2015-05-28 13:08:26Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "bytecodes.h"

char *
byteCodeString (enum BYTECODE b)
{
  char *r;
  switch (b)
    {
    case NOP:
      r = "nop";
      break;
    case PUSH:
      r = "push";
      break;
    case APUSH:
      r = "apush";
      break;
    case POP:
      r = "pop";
      break;
    case MOVE:
      r = "move";
      break;
    case STORE:
      r = "store";
      break;
    case CLRF:
      r = "clrf";
      break;
    case ADD:
      r = "add";
      break;
    case SUB:
      r = "sub";
      break;
    case MULT:
      r = "mult";
      break;
    case DIV:
      r = "div";
      break;
    case NEG:
      r = "neg";
      break;
    case POW:
      r = "pow";
      break;
    case EXP:
      r = "exp";
      break;
    case SIN:
      r = "sin";
      break;
    case COS:
      r = "cos";
      break;
    case SQRT:
      r = "sqrt";
    default:
      printf ("instruction not understood %d\n", b);
      exit (EXIT_FAILURE);
    }
  return r;
}
