/*
 (c)GAFit toolkit $Id: banner.c 510 2025-04-22 14:23:13Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
#include "core.h"
#include "job.h"
#include "parameters/parameters.h"
#include "inputline/line.h"
#include "banner.h"

char *
build (void)
{
  char *build = GAFit_BUILD;
  static char s[50] = { 0 };
  int n = atoi (build);
  sprintf (s, " %d", n);
  return s;
}


void
printIt (FILE * where, char *what)
{
  fprintf (where, "%s\n", what);
}

void
printLine (FILE * where, char *s, int lmargin, int total)
{
  char buffer[total + 1];
  int l;
  buffer[0] = '\0';
  sprintf (buffer, "|%*s%s", lmargin, " ", s);
  l = strlen (buffer);
  sprintf (buffer + l, "%*s|", total - l - 1, " ");
  printIt (where, buffer);
}

void
printBar (FILE * where, int len)
{
  char buffer[len + 1];
  char *p = buffer;
  int i = 0;
  *p = '+';
  p++;
  while (i < len - 2)
    {
      *p = '-';
      p++;
      i++;
    }
  *p = '+';
  p++;
  *p = '\0';
  printIt (where, buffer);
}


void
printCenter (FILE * where, char *s, int total)
{
  int lmargin = (total - strlen (s)) / 2;
  printLine (where, s, lmargin, total);
}

void
printBox (FILE * where, char *s)
{
  int lenbar = LENBAR;
  printBar (where, lenbar);
  printCenter (where, s, lenbar);
  printBar (where, lenbar);
}

void
printText (FILE * f, char *text, int lmargin, int rmargin, int lenbar)
{
  int width = lenbar - lmargin - rmargin;
  char *pi, *pf;
  int wtext = strlen (text);
  char buffer[width + 1];
  pi = text;
  pf = text;
  while ((pf - text) < wtext)
    {
      while (pf - pi < width)
	{
	  if ((pf - text) >= wtext)
	    {
	      snprintf (buffer, pf - pi, "%s", pi);
	      printLine (f, buffer, lmargin, lenbar);
	      return;
	    }
	  pf++;
	}
      while (*(pf - 1) != ' ' && pf > pi)
	pf--;
      snprintf (buffer, pf - pi, "%s", pi);
      printLine (f, buffer, lmargin, lenbar);
      pi = pf - 1;
    }

}

char *
charGetTime (void)
{
  struct timeval tv;
  struct timezone tz;
  gettimeofday (&tv, &tz);
  return ctime (&tv.tv_sec);
}


void
banner (FILE * f, JOB * jo)
{
  int lenbar = LENBAR;
  char tm[lenbar + 1];
  char buffer[lenbar + 1];
  char timebuf[26];		//ctime string output lenght
  int rmargin;
  int lmargin = LMARGIN;

  if (FileExist (jo->file))
    {
      jo->test = GetUIntParameter (jo->file, "job", "test", TEST);
      if (jo->test)
	snprintf (tm, lenbar, "**TEST MODE, seed:%d **", jo->test);
      else
	snprintf (tm, lenbar, " ");
    }


  snprintf (timebuf, 25, "%s", charGetTime ());

  printBar (f, lenbar);

  snprintf (buffer, lenbar, "GAFit %s Build:%s  %s", PACKAGE_VERSION,
	    build (), tm + 1);

  rmargin = lmargin;
  printLine (f, buffer, lmargin, lenbar);
  printLine (f, timebuf, lmargin, lenbar);
  printBar (f, lenbar);
  snprintf (buffer, lenbar, "Cite this program as GAFit %s:",
	    PACKAGE_VERSION);
  printLine (f, "", 0, lenbar);
  printText (f, buffer, lmargin, rmargin, lenbar);
  printLine (f, "", 0, lenbar);
  printText (f, CITATION0, lmargin, rmargin, lenbar);
  printText (f, CITATION1, lmargin, rmargin, lenbar);
  printBar (f, lenbar);
  fflush (f);
}

void
printSettings (FILE * f, JOB * jo)
{
  int lenbar = LENBAR;
  char buffer[lenbar + 1];
  int lmargin = LMARGIN;
  //int rmargin = lmargin;
  printBar (f, lenbar);
  printLine (f, "Settings for job", lmargin, lenbar);
  printBar (f, lenbar);
  snprintf (buffer, lenbar, "Command:[%s]", jo->external_command);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "Bounds:[%s]", jo->external_bounds);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "External input:[%s]", jo->external_input);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "External fit:[%s]", jo->external_fit);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "Total coefficients: %d", jo->external_coefs);
  printLine (f, buffer, lmargin, lenbar);
  snprintf
    (buffer, lenbar, "Print options: runs %s, ga settings %s",
     jo->print_run ? "yes" : "no", jo->print_ga ? "yes" : "no");
  printLine (f, buffer, lmargin, lenbar);
}


void
printGa (FILE * f, JOB * jo)
{
  int lenbar = LENBAR;
  char buffer[lenbar + 1];
  int lmargin = LMARGIN;
  //int rmargin = lmargin;

  char *tover[] = LIST_CX_TYPE;
  char *tmut[] = LIST_MUT_TYPE;
  char *tdir[] = LIST_DIRECTION;
  char *tmtin[] = LIST_MUT_INTEGER;

  printBar (f, lenbar);
  printLine (f, "Settings for GA", lmargin, lenbar);
  printBar (f, lenbar);
  snprintf (buffer, lenbar, "runs:             %d", jo->runs);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "evaluations:      %d", jo->evaluations);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "population:       %d", jo->pop_size);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "crossover:        %s", tover[jo->ga.cx_type]);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "cossover rate:    %lf", jo->ga.p_cx);
  printLine (f, buffer, lmargin + 3, lenbar);
  snprintf (buffer, lenbar, "blx_alpha:        %lf", jo->ga.blx_alpha);
  printLine (f, buffer, lmargin + 3, lenbar);
  snprintf (buffer, lenbar, "eta_sbx:          %lf", jo->ga.eta_sbx);
  printLine (f, buffer, lmargin + 3, lenbar);
  snprintf (buffer, lenbar, "mutation:         %s",
	    tmut[jo->ga.mutation_type]);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "mutation rate:    %lf", jo->ga.p_mt);
  printLine (f, buffer, lmargin + 3, lenbar);
  snprintf (buffer, lenbar, "sigma:            %lf", jo->ga.sigma);
  printLine (f, buffer, lmargin + 3, lenbar);
  snprintf (buffer, lenbar, "integer mutation: %s",
	    tmtin[jo->ga.mutation_integer]);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "elitism:          %s",
	    jo->ga.elite ? "yes" : "no");
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "tournament size:  %d", jo->ga.size_k);
  printLine (f, buffer, lmargin, lenbar);
  snprintf (buffer, lenbar, "direction:        %s", tdir[jo->dir]);
  printLine (f, buffer, lmargin, lenbar);
}

void
printRun (FILE * f, int run)
{
  int lenbar = LENBAR;
  int lmargin = LMARGIN;
  char buffer[lenbar + 1];
  snprintf (buffer, lenbar, "run: %d", run);
  printLine (f, buffer, lmargin, lenbar);
}

void
printRand (FILE * f, char *randtext)
{
  int lenbar = LENBAR;
  int lmargin = LMARGIN;
  printLine (f, randtext, lmargin, lenbar);
}

void
printRuRa (FILE * f)
{
  printBar (f, LENBAR);
}
