/*
 (c)GAFit toolkit $Id: application.c 505 2025-01-25 02:06:51Z ro $
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include "nullist/nllist.h"
#include "parameters/parameters.h"
#include "core.h"
#include "flyctl/flyctl.h"
#include "application.h"

/// Only 'job' section configuration!
APPCONF APP_CONF[] = {
  {"intermolecular", "job", "type", "external auto"}
  ,
  {"intermolecular", "job", "command", "./external-intpot.sh"}
  ,
  {"multi", "job", "type", "external auto"}
  ,
  {"multi", "job", "command", "./external-multi.sh"}
  ,
  {"mopac", "job", "type", "external auto"}
  ,
  {"mopac", "job", "command", "./external-mopac.sh"}
  ,
  {"charmm", "job", "type", "external auto"}
  ,
  {"charmm", "job", "command", "./chmm.sh"}
  ,
  {"mvariable", "job", "type", "external auto"}
  ,
  {"mvariable", "job", "command", "mvariable"}
  ,
  {"generic", "job", "type", "external auto"}
  ,
  {"generic", "job", "command", "./external-generic.sh"}
  ,
  {NULL}
};

APPSCRIPT APP_SCR[] = {
  {"intermolecular", 0, 1, 0,
   "#!/bin/sh\n"		//**
   "\n"				//**
   "export EXTERNAL_INPUT=intpot.input\n"	//**
   "export EXTERNAL_FIT=intpot.fit\n"	//**
   "export BOUNDS_FILE=bounds.txt\n"	//**
   "\n"				//**
   "intpot $1 bulk\n"		//**
   }
  ,
  {"multi", 0, 1, 0,
   "#!/bin/sh\n"		//**
   "\n"				//**
   "export EXTERNAL_INPUT=multi.input\n"	//**
   "export EXTERNAL_FIT=multi.fit\n"	//**
   "export BOUNDS_FILE=bounds.txt\n"	//**
   "\n"				//**
   "if ! multi $1 bulk; then\n"	//**
   "echo 'failed'>>__STOP__\n" "fi\n"}
  ,
  {"mopac", 1, 1, 1,
   "#!/bin/sh\n"		//**
   "export MOPAC_LICENSE=EXEC_00\n"	//**
   "export MOPAC_EXECUTABLE=EXEC_01\n"	//**
   "NCORES00\n"			//**
   "\n"				//**
   "injector $1 bulk\n"		//**
   "if [ \"$1\" -ne \"0\" ]\n"	//**
   "then\n"			//**
   "	shepherd\n"		//**
   "	extractor $1\n"		//**
   "	fitter $1\n"		//**
   "fi\n"			//**
   }
  ,
  {"charmm", 1, 1, 1,
   "#!/bin/sh\n"		//**
   "export CHARMM_EXECUTABLE=EXEC_00/EXEC_01\n"	//**
   "REFERENCE_GEOMETRY\n"	//**
   "\n"				//**
   "if [ \"$1\" -ne \"0\" ]\n"	//**
   "then\n"			//**
   "        chmrunner $1 CALC_ENERGIES\n"	//**
   "else\n"			//**
   "        chmconfigurator $1\n"	//**
   "        chmreference $1\n"	//**
   "fi\n"			//**
   }
  ,
  {"mvariable", 0, 0, 0,
   ""}
  ,
  {"generic", 0, 1, 1,
   "#!/bin/sh\n"		//**
   "INPUT_TEMPLATE00\n"		//**
   "export EXTERNAL_INPUT=external.input\n"	//**
   "export EXTERNAL_FIT=external.fit\n"	//**
   "NCORES00\n"			//**
   "EXTERNAL_EXECUTABLE00\n"	//**
   "REFERENCE_VALUES00\n"	//**
   "\n"				//**
   "if [ \"$1\" -eq \"0\" ]\n"	//**
   "then\n"			//**
   "        templanalyzer\n"	//**
   "else\n"			//**
   "        grunner $1\n"	//**
   "fi\n"			//**
   }
  ,
  {NULL}
};

APPOPTIONS APP_OPT[] = {
  {"charmm", "job", "calculated energies", "CALC_ENERGIES", "%s"}
  ,
  {"charmm", "job", "refgeom", "REFERENCE_GEOMETRY",
   "export CHARMM_REFERENCE_GEOM=%s"}
  ,
  {"mopac", "job", "ncores", "NCORES00", "export SHEPHERD_CORES=%s"}
  ,
  {"generic", "job", "ncores", "NCORES00", "export N_CORES=%s"}
  ,
  {"generic", "job", "template", "INPUT_TEMPLATE00",
   "export INPUT_TEMPLATE=\"%s\""}
  ,
  {"generic", "job", "executable", "EXTERNAL_EXECUTABLE00",
   "export EXTERNAL_EXECUTABLE=%s"}
  ,
  {"generic", "job", "reference values", "REFERENCE_VALUES00",
   "export REFERENCE_VALUES=%s"}
  ,
  {NULL}
};

char **
appList (void)
{
  char **list = NULL;

  APPCONF *p = APP_CONF;
  while (p->app)
    {
      list = nllAddDup (list, p->app);
      p++;
    }
  list = nllUnic (list);
  return list;
}


char **
secList (void)
{
  char **list = NULL;

  APPCONF *p = APP_CONF;
  while (p->app)
    {
      list = nllAddDup (list, p->section);
      p++;
    }
  list = nllUnic (list);
  return list;
}

void
appWriteJob (int num)
{
  FILE *conf;

  APPCONF *p;

  char **list = appList ();
  char **sections = secList ();

  conf = fopen (APP_RESPONSE, "w");

  for (int i = 0; i < nllCount (sections); i++)
    {
      fprintf (conf, "[%s]\n", nllString (sections, i));

      p = APP_CONF;

      while (p->app)
	{
	  if (!strcmp (p->app, nllString (list, num))
	      && !strcmp (p->section, nllString (sections, i)))
	    {
	      fprintf (conf, "%s: %s\n", p->key, p->value);
	    }
	  p++;
	}
      fprintf (conf, "\n");
    }
  fclose (conf);
  nllClear (list);
}


///***********************************EXEC***********************
int
appRequireExec (char *which)
{
  APPSCRIPT *s = APP_SCR;
  while (s->app)
    {
      if (strcmp (s->app, which) == 0)
	return s->requireExec;
      s++;
    }
  return 0;
}

char **
splitExec (char *exec)
{
  char **retlist = NULL;
  char *cmd;
  char *test;
  test = strdup (exec);
  cmd = rindex (test, PATH_SEPARATOR);
  *cmd = 0;
  cmd = cmd + 1;
  retlist = nllAddDup (retlist, test);
  retlist = nllAddDup (retlist, cmd);
  free (test);
  return retlist;
}

char *
replaceOptions (char *s, char **options, char **toReplace)
{
  int n;

  char **list = nllListParser (s, toReplace);

  free (s);

  n = nllCount (options);

  for (int i = 0; i < n; i++)
    list =
      nllReplace (list, nllString (toReplace, i),
		  strdup (nllString (options, i)));


  s = nllGlue (list, "");
  nllClear (list);
  return s;
}

///***********************************OPTIONS********************
int
appRequireOptions (char *which)
{
  APPSCRIPT *s = APP_SCR;
  while (s->app)
    {
      if (strcmp (s->app, which) == 0)
	return s->moreOptions;
      s++;
    }
  return 0;
}

void
appGetOptions (char *file, char *which, char ***vreplace, char ***vvalues)
{
  char tmp[APP_EXEC_LEN];
  char tmp2[APP_EXEC_LEN];
  char **replace = NULL;
  char **values = NULL;
  APPOPTIONS *p = APP_OPT;

  tmp2[0] = '\0';

  while (p->app)
    {
      if (strcmp (p->app, which) == 0)
	{
	  GetStringParameter (file, p->section, p->key, "", tmp,
			      APP_EXEC_LEN);
	  snprintf (tmp2, APP_EXEC_LEN, p->format, tmp);
	  replace = nllAdd (replace, strdup (tmp2));
	  values = nllAdd (values, strdup (p->replaceMarker));
	}
      p++;
    }

  *vreplace = replace;
  *vvalues = values;
}

///***********************************SHELL SCRIPT***************
int
appRequireCreateScript (char *which)
{
  APPSCRIPT *s = APP_SCR;
  while (s->app)
    {
      if (strcmp (s->app, which) == 0)
	return s->createScript;
      s++;
    }
  return 0;
}


char *
appShellScriptExec (char *text, char *exectext)
{
  char **etokens = nllBuild ("EXEC_00", "EXEC_01", NULL);

  char **sexec = splitExec (exectext);

  if (nllCount (sexec) != 2)
    fcStopIt ("error procesing shell scripts options: exec\n");

  text = replaceOptions (text, sexec, etokens);

  nllClear (sexec);
  nllClear (etokens);

  return text;
}

char *
scriptName (char *which)
{
  APPCONF *p = APP_CONF;
  while (p->app)
    {
      if (!strcmp (p->app, which) && !strcmp (p->section, "job")
	  && !strcmp (p->key, "command"))
	{
	  return p->value;
	}
      p++;
    }
  return NULL;
}

char *
scriptText (char *which)
{
  APPSCRIPT *s = APP_SCR;

  while (s->app)
    {
      {
	if (strcmp (s->app, which) == 0)
	  {
	    return strdup (s->shellScript);
	  }
	s++;
      }
    }
  return NULL;
}

void
appWriteScript (char *script_name, char *text)
{
  FILE *f = fopen (script_name, "w");
  fprintf (f, "%s\n", text);
  fclose (f);

  //execute bit + others....
  chmod (script_name,
	 S_IRUSR | S_IWUSR | S_IXUSR | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);
}

char *
appConfigure (char *file)
{
  static char *response = APP_RESPONSE;
  static char exec[APP_EXEC_LEN];
  char *which;
  char **appl;

  char *script_text = NULL;
  char *script_name = NULL;
  char **replace;
  char **values;

  int appn;
  appl = appList ();
  appn =
    GetFromSetParameter (file, "job", "application", appl,
			 JOB_TYPE_APPLICATION, 0);
  // save app name
  which = strdup (nllString (appl, appn));

  nllClear (appl);

  if (appn >= 0)
    {
      appWriteJob (appn);

      script_name = scriptName (which);

      if (script_name)
	{
	  if (appRequireCreateScript (which))
	    {
	      script_text = scriptText (which);

	      // if a exec path is required...
	      if (appRequireExec (which))
		{
		  GetStringParameter (file, "job", "exec", " ", exec,
				      APP_EXEC_LEN);
		  if (strcmp (exec, " ") == 0)
		    fcStopIt ("exec line required\n");
		  script_text = appShellScriptExec (script_text, exec);
		}

	      //printf ("scr=%s\n", script_text);

	      // if there are more options...
	      if (appRequireOptions (which))
		{
		  appGetOptions (file, which, &replace, &values);
		  script_text = replaceOptions (script_text, replace, values);
		}
	      //printf ("scr w options=%s\n", script_text);
	      appWriteScript (script_name, script_text);
	    }
	  //control tranfered to 'application' file
	  file = response;
	  printf ("application settings: %s\n", which);
	}
    }
  free (which);
  return file;
}
