/*
 (c)GAFit toolkit $Id: testgeneric.c 378 2019-12-04 17:52:09Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define MAXLINE 100

#define NINT 1
#define NDOUBLE 2

#define OUTPUT_EXT ".output"
#define INPUT_EXT ".input"

union Number
{
  int n;
  double d;
};

typedef union Number NUMBER;

NUMBER
getThing (FILE * f, int type)
{
  char line[MAXLINE + 1];
  NUMBER number;
  number.n = 0;
  while (fgets (line, MAXLINE, f) != NULL)
    {
      char *p = line;
      while (*p == ' ' || *p == '\t')
	p++;
      if (*p == '\r' || *p == '\n')
	continue;
      switch (type)
	{
	case NINT:
	  sscanf (line, "%d", &number.n);
	  return number;
	case NDOUBLE:
	  sscanf (line, "%lf", &number.d);
	  return number;
	}
      break;
    }
  return number;
}

int
getInt (FILE * f)
{
  return getThing (f, NINT).n;
}

double
getDouble (FILE * f)
{
  return getThing (f, NDOUBLE).d;
}

double
func (double x, double a[], int n)
{
  double ret = 0;
  int i;
  for (i = 0; i < n; i++)
    {
      ret += a[i] * pow (x, (double) i);
    }
  return ret;
}

int
main (int argc, char **argv)
{
  double *coefs;
  double *points;
  double *yf;

  int ncoefs, npoints;

  FILE *f;

  f = stdin;
  npoints = getInt (f);
  points = (double *) malloc (npoints * sizeof (double));
  yf = (double *) malloc (npoints * sizeof (double));

  for (int i = 0; i < npoints; i++)
    {
      points[i] = getDouble (f);
    }

  ncoefs = getInt (f);
  coefs = (double *) malloc (ncoefs * sizeof (double));

  for (int i = 0; i < ncoefs; i++)
    {
      coefs[i] = getDouble (f);
    }

  f = stdout;
  fprintf (f, "processing input\n");
  for (int i = 0; i < npoints; i++)
    {
      yf[i] = func (points[i], coefs, ncoefs);
      fprintf (f, "%lf\n", yf[i]);
    }
  fprintf (f, "done\n");
}
