#!/bin/sh

#echo "---------------- begin $1 ------------------"

#scratch folder to run each individual calculation
SCRATCH="scratch"

# one temporary folder for each calculation
TMP=$SCRATCH/$1


# creating the temporary folder, '-p' ensures all path is created
mkdir -p $TMP

# move template files to temporary folder
mv $1.template $TMP/template

# execute calculation
./testgeneric < $TMP/template  > $TMP/output
./extractdata < $TMP/output > $TMP/data

# extract data
gfitter $1 $TMP/data 

# delete templates
rm $1.template  

# delete temporary folder
rm -r $TMP

# echo "----- end $1 ----- "
