!      
!  (c) GAFit toolkit $Id$      
!     

      MODULE cvariables
      IMPLICIT NONE
      SAVE
! external values,coefs and fit files
      character*100 ::fvalues,fcoeficients,ffit
      double precision, allocatable :: cfs(:),x(:),y(:)
      integer ndata,coefs
      end
  
! target polynomial (degree n)      
      double precision FUNCTION f( x,a, n)
      integer n
      double precision x
      double precision a(n)
      integer i
      f=0
      do i=1,n
        f=f+a(i)*x**(i-1)
      enddo
      end
      
      program poly
      use cvariables

      character*100 line
      integer i
      double precision total,fit,f
      
! first we are going to count the external values      
      ndata=0
      fvalues='external.values'
      open(10,file=fvalues,status='old',err=101)
! counting data lines      
      do while(.true.)
       read(10,fmt='(A)',end=102) line
       ndata=ndata+1
      enddo
  102 continue
 
! second, allocate space for external values
      allocate (x(ndata))
      allocate (y(ndata))

! third, reading data      
      rewind(10)
      do i=1,ndata
      	read (10,*) x(i),y(i)
      enddo
      close(10)
        
! we are going to read the gafit coefficients          
      coefs=0
      fcoeficients='external.input'
      open(11,file=fcoeficients,status='old',err=111)
      
! check how many coefficients per vector set
! tip: a blank line ends each set      
      do while(.true.)
        read (11,fmt='(A)',end=112) line
        if (len_trim(line) .eq. 0) then
! here is the blank line
        	goto 112
        endif
        coefs=coefs+1
      enddo
  112 continue
  
! move pointer to file start   
      rewind(11)

! allocate space for one vector at a time
      allocate (cfs(coefs))

! opening the result file
      ffit='external.fit'
      open(12,file=ffit)
      
      do while(.true.)
        fit=0
! read ONE coefficient set
       do i=1,coefs
        read(11,*,end=113) cfs(i)
       enddo
! calculate fit with the coefficient set
       do i=1,ndata
        fit=fit+(y(i)-f(x(i),cfs,coefs))**2
       enddo       
! write fit       	
       write(12,*) fit

      enddo
      
  113 continue
      close(11)
      close(12)      
          
      return
      
  101 continue
      print *,'error ',fvalues
!     compile with src/flyctl 
      call fstopit('error fvalues')    
      return
  111 continue
      print *,'error ',fcoeficients
!     compile with src/flyctl src/InputLine
      call fstopit('error fcoeficients')      
      end

!     compile with src/flyctl src/InputLine
      subroutine fstopit(reason)
      character (len=*) reason
      call fcCStopIt(reason//CHAR(0))
      stop
      end
                              
                              