/*
 (c)GAFit toolkit $Id: exponential.c 378 2019-12-04 17:52:09Z ro $
*/
#if HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#define MAXLINE 100

double
func (double x, double a[], int n)
{
  double ret = 0;
  int i;
  for (i = 0; i < n; i+=2)
    {
      ret += a[i] * exp (-a[i+1]*x);
    }
  return ret;
}

int
main (void)
{
  char line[MAXLINE + 1];
  double *coef = NULL;
  double *valuesx = NULL, *valuesy = NULL;
  double fit, number0, number1, tmp;
  int i, j, ncoefs, mvalues, tcoefs;
  int first, ok;

  FILE *f, *out;

  mvalues = 0;
  f = fopen ("exponential.values", "r");
  while (fgets (line, MAXLINE, f) != NULL)
    {
      sscanf (line, "%lf%lf", &number0, &number1);
      valuesx = (double *) realloc (valuesx, sizeof (double) * (mvalues + 1));
      valuesy = (double *) realloc (valuesy, sizeof (double) * (mvalues + 1));
      valuesx[mvalues] = number0;
      valuesy[mvalues] = number1;
      mvalues++;
    }
  fclose (f);

  ok = 1;
  first = 1;
  ncoefs = 0;
  out = fopen ("exponential.fit", "w");
  f = fopen ("exponential.input", "r");
  if (!f)
    {
      printf ("no file exponential.input\n");
      exit (EXIT_FAILURE);
    }
  while (ok)
    {
      while (fgets (line, MAXLINE, f) != NULL)
	{
	  char *p = line;
	  while (*p == ' ' || *p == '\t')
	    p++;
	  if (*p == '\r' || *p == '\n')
	    break;

	  sscanf (line, "%lf", &number0);
	  ncoefs++;

	  if (first)
	    {
	      coef = (double *) realloc (coef, sizeof (double) * (ncoefs));
	      tcoefs = ncoefs;
	    }
	  coef[ncoefs - 1] = number0;
	}
      if ((tcoefs % 2) == 1)
	{
	  fclose (f);
	  fclose (out);
	  out = fopen ("__STOP__", "w");
	  fprintf (out, "odd number of coefficients");
	  fclose (out);
	  exit (1);
	}
      if (feof (f))
	ok = 0;
      first = 0;
      ncoefs = 0;
      fit = 0;
      for (i = 0; i < mvalues; i++)
	{
	  tmp = func (valuesx[i], coef, tcoefs);
	  fit += (tmp - valuesy[i]) * (tmp - valuesy[i]);
	}
      fprintf (out, "%lf\n", fit);
    }
  fclose (out);
  fclose (f);
}
